/*
	Brosers Based AIR Help Recovery script for BB AIR creaed by RoboHelp 10
	
	Copyright 2012 - Willam van Weelden - All rights reserved.
	
	Visit me on www.wvanweelden.eu
*/

/*
	Willam van Weelden RoboHelp ExtendScript library loader
	
	Include this file to load the Willam van Weelden ExtendScript library
	
*/

var libInit = false;//Set to true when the library is loaded.
var libVersion = 20120515;//Version of the library.

if(typeof(RoboHelp) != "undefined")
{
	
/* Global library variables */
	
	/* You may change the values of these variables */
	var v7Location = null;

	/* Do not change the value of the variables below this line. */
	var currentProject = null;
	var xpjextension = ".xpj";
	//Container files
	var FMContainer = "RHFrameDocs.apj";
	var WordContainer = "RHWordDocs.apj";
	var aliasfileextension = ".ali";
	var mapfileextension = new Array(".h", ".hh", ".hm");
	//Linked file information variables
	var LinkedFMDocs = false;
	var LinkedWordDocs = false;
	//CSH information variables
	var CSH = false;
	var MapNumbers = new Array();
	var TopicIds = new Array();
	var CSHTopicidKey = "topicid";
	var CSHMapnumberKey = "mapnumber";
	var CSHTopicKey = "topic";
	var CSHHighestNumberTaken = false;
	var CSHNoMoreMapNumbers = false;
	var CSHLastAssignedNumber = false;
	
	/* Include the library files */
Array.prototype.max = function() {
	var highest = false;
	for(var i = 0; i<this.length; i++) {
		if(!isNaN(parseFloat(this[i]))) {
			if(isNaN(highest))
				highest = parseFloat(this[i]);
			else if(parseFloat(this[i]) > highest)
				highest = parseFloat(this[i]);
	}
}
return highest;
}
Array.prototype.min = function() {
	var lowest = false;
	for(var i = 0; i<this.length; i++) {
		if(!isNaN(parseFloat(this[i]))) {
			if(isNaN(lowest))
				lowest = parseFloat(this[i]);
			else if(parseFloat(this[i]) < lowest)
				lowest = parseFloat(this[i]);
	}
}
return lowest;
}

Array.prototype.remove = function(from, to) {
	// Array Remove - By John Resig (MIT Licensed)
	//http://ejohn.org/blog/javascript-array-remove/
	var rest = this.slice((to || from) + 1 || this.length);
	this.length = from < 0 ? this.length + from : from;
	return this.push.apply(this, rest);
}

Array.prototype.toLowerCase = function() {
                var lowercasearray = new Array();
                for(var i = 0; i<this.length; i++)
                {
                               if(typeof(this[i]) == "string")
                                               lowercasearray.push(this[i].toLowerCase());
                               else
                                               lowercasearray.push(this[i]);
                }
                return lowercasearray;
}


function in_array (needle, haystack, strict) {
	
	if(is_array(needle))
	{
		alert("in_array expects first parameter to be a string. Array given.");
		return false;
	}
	else if(!is_array(haystack))
	{
		alert("in_array expects second parameter to be an array.")
		return false;
	}
	
	if(!strict)
		strict = false;
		
	var inarray = false;
	for(var i = 0; i<haystack.length; i++)
	{	
		if(strict)
		{
			if(needle === haystack[i])
			{
				inarray = true;
				break;
			}
		}
		else
		{
			if(needle == haystack[i])
			{
				inarray = true;
				break;
			}
		}
	}
	return inarray;
}
function is_array(object) {
	if(!isValidType(object))
		return false;
	else if(object.constructor.toString().indexOf("Array") == -1)
		return false;
	else
		return true;
}
function ExecuteBatchFile(command, waitforbatch) {
                
	if(command.isEmpty())
		return false;

	if(!waitforbatch)
		if(waitforbatch != false)
			waitforbatch = true;

	if(currentProject != null)
		var path = projectpath();
	else//No project. Save batfile to fallback directory
		var path = 'C:/';

	var batFileName = 'ExtendScriptBatchFile';
	var batFileExtension = '.bat';
	var batFile = new File(path+batFileName+batFileExtension);
	if(batFile.exists) {
		var i  = 0;
		while(batFile.exists) {
			i++;
			batFile = new File(path+batFileName+i+batFileExtension);
		}
	}

	command+= "\ndel /F /Q \"" + batFile.fsName + "\"";

	batFile.writeFile(command, false);
	if(!isFile(batFile, true))
		return false;

	batFile.execute();

	//Wait on batch file execution if needed
	if(waitforbatch) {
		while(batFile.exists) {
			msg(".");
			$.sleep(100);
		}
	}
	return true;
}

function openURL(url) {
	ExecuteBatchFile("start "+url+"  \n", false);
}
function getNextMapNumber() {
                
	//Assume that the mapnumbers are simple incremented numbers
	var lowestnumber = 1;
	var highestnumber = 4294967295;

	if(MapNumbers.length == 0)
		var nextnumber = lowestnumber;
	else if(!CSHHighestNumberTaken)//The hightest number has not yet been taken, or is not know to be taken yet.
		var nextnumber = MapNumbers.max() + 1;
	else
		var nextnumber = highestnumber+1;//Take the highest number so the search loop will start.

	if(nextnumber > highestnumber) {

		CSHHighestNumberTaken = true;//The highest number has been taken. No need to use the .max() method next time this function is called. Saves time.

		if(!CSHNoMoreMapNumbers) {//By default, there are mapnumbers.

			if(CSHLastAssignedNumber == false)//Check to see if the function already assigned a MapNumber before. No need to start counting at 1 when there is a higher number.
				nextnumber = lowestnumber;
			else
				nextnumber = CSHLastAssignedNumber+1;

			//The highest number has been taken. Determine if there is another number we can use.
			while(in_array(nextnumber, MapNumbers)) {
				nextnumber++;
			}

			if(nextnumber > highestnumber) {
				nextnumber = null;
				CSHNoMoreMapNumbers = true;//There are no more mapnumbers available. No need to loop the set numbers anymore when this function is called again. Saves time.
			}
		} else {
			nextnumber = null;
		}
	}
	if(nextnumber == null)
		alert("There are no more MapId's available in this project.");

	CSHLastAssignedNumber = nextnumber;

	return nextnumber;
}

function unloadCSH() {
	/*
		Reset CSH to false to allow the script to check if the CSH is already initialized.
		Called by unloadcurrentproject();
	*/
	CSH = false;
	MapNumbers = new Array();
	TopicIds = new Array();
}
function loadCSH() {
	/*
		This function loads all the CSH (MapId's, TopicId's and Topic references) into the array CSH.
		Done for easy searching so you don't have to parse all CSH file every time you need this info.
	*/
	
	msg("\nLoading all the project's Context Sensitivity\n");
	
	var aliasfile = "";
	var mapfiles = new Array();
	
	CSH = new Array();
	MapNumbers = new Array();
	TopicIds = new Array();
	
	var CSHtmpArray = new Array();
	
	for(var i = 1; i<=currentProject.FileManager.count; i++) {
		
		var file = currentProject.FileManager.item(i);
		if(file.extension == aliasfileextension)
			aliasfile = new File(file.path);
		else if(in_array(file.extension, mapfileextension))
			mapfiles.push(new File(file.path));
	}
	
	//Load all project topicid's and map#
	for(var i = 0; i<mapfiles.length; i++) {
		var mapfile = mapfiles[i];
		var mapfilecontent = mapfile.content().split("\n");
		
		for(var j = 0; j<mapfilecontent.length;j++) {
			var line = mapfilecontent[j];
			//Skip empty lines
			if(line.trim() != "") {
				
				//Both Map# and TopicId are mandatory. So no need to check that both exist
				line = line.replace("#define ", "");
				
				//Separator can be a tab or a space
				if(line.match("\t")) {
					line = line.split("\t");
				} else {
					line = line.split(" ");
				}
				
				var thislinearray = new Array();
				//Load topicid's
				thislinearray[CSHTopicidKey] = line[0];
				TopicIds.push(line[0]);
				//Load map#
				thislinearray[CSHMapnumberKey] = parseFloat(line[1]);
				MapNumbers.push(line[1]);
				CSHtmpArray.push(thislinearray);
			}
		}
	}
	
	//Now get all aliasses and combine the topicid's/Map# with the correct topics
	var AliasXML = new XML(aliasfile.content());
	var Aliasses = AliasXML.children();
	for(var i = 0; i<Aliasses.length(); i++) {
		var alias = Aliasses[i];
		
		//The alias file only contains links between topicid and topic. CSH without assigned topic are not in this file.
		var topicid = alias.attribute("name").toString();
		var topic = alias.attribute("link").toString().toLowerCase().replace(/\\/g,"/");
		for(var j = 0; j<CSHtmpArray.length; j++) {
			if(CSHtmpArray[j][CSHTopicidKey] == topicid) {
				CSHtmpArray[j][CSHTopicKey] = topic;
				CSH.push(CSHtmpArray[j]);
				CSHtmpArray.remove(j);
				break;
			}
			
		}
		
	}
	/*
		Elements still in the array are elements without a topic assigned. These elements need to be pushed to the CSH array too.
	*/
	for(var i = 0; i<CSHtmpArray.length; i++) {
		CSHtmpArray[i][CSHTopicKey] = false;//No topic available
		CSH.push(CSHtmpArray[i]);
	}
	msg("Finished loading Context Sensitivity\n");
}
/*
	For File.convertUTF8, see utf8.jsxinc
	For File.zip(), see zip.jsxinc
*/
File.prototype.content = function(content, encoding) {
	file = this;
	if(!content)
	   content = false;

	if(!encoding || encoding == true)
	   encoding = "UTF-8";
			   
	if(!content)
	   return file.readFile("UTF-8");
	else {
	   file.writeFile(content, encoding);
	   return true;
	}
}
File.prototype.extension = function() {
    return extension(this.fsName);
}
File.prototype.folder = function() {
    return folder(this.fsName);
}
File.prototype.readFile = function (encoding) {
	var thisfile = this;
	var szFilePath = thisfile.fsName;
	
	if(!isFile(thisfile))
	   return null;
	
	if(!encoding || encoding == true)
	   encoding == "UTF-8";
	
	//if it is RH9 then we will use the readWholeFile function
	if (IsRoboHelp9OrLater())
	   return RoboHelp.readWholeFile(szFilePath); //this takes care of BOM, encoding and all
    else {
	   var szRetVal = "";
	   var fileObj = new File(szFilePath);
	   fileObj.encoding = encoding;
	   fileObj.open("r");
	   while (!fileObj.eof) {
		   szRetVal += fileObj.readln()+"\n";
	   }
	   fileObj.close();
	   return szRetVal;
	}
}
File.prototype.writeFile = function (szOutput, encoding) {
	var thisfile = this;
	var szFilePath = thisfile.fsName;
	
	if(!encoding || encoding == true)
	   encoding = "UTF-8";
	
	var bSuccess = false;
	
	var fileObj = new File(szFilePath);
	fileObj.encoding = encoding;
	fileObj.open("w");
	fileObj.write(szOutput);
	fileObj.close();      
}

function extension(filename) {
	var ext = "";//If no extension, return an empty string.
	var index = filename.lastIndexOf(".");
	if(index != -1) {
		ext = filename.substr(index, filename.length - index).toLowerCase();
	}
	return ext;
}
function filename(absolutepath) {//Returns filename from absolute path.
	absolutepath = absolutepath.replace(/\\/g, "/");
	return absolutepath.substring(absolutepath.lastIndexOf("/")+1);
}
function FilePathExists(absolutepath) {
	var file = new File(absolutepath);
	return isFile(file, true);
}
function folder(absolutepath) {//Returns path from absolute path to file
	absolutepath = absolutepath.replace(/\\/g,"/");
	return absolutepath.substring(0,absolutepath.lastIndexOf("/"));
}
function isValidFilePath(path, filename) {
	if(!isValidType(path))
        return false;
	else if(is_array(path))
		return false;
    
    var bRetVal = !path.isEmpty() && FilePathExists(path);
    if (bRetVal) {
        bRetVal = false;
        path = path.toLowerCase();
        if (path.length > filename.length) {
            path = path.substr(path.length - filename.length);
            if (path == filename) {
                bRetVal = true;
            }
        }
    }
    return bRetVal;
}
function isFile(file, mustexist) {//Check whether an object is a file object and optionally whether the file exists on the file system.
	if(!mustexist)
		mustexist = false;
	
	var isfile = false;
	if(file instanceof File)
	{
		isfile = true;
		
		if(mustexist)
			if(!file.exists)
				isfile = false;
	}
	return isfile;
}
/*
	For Folder.zip(), see zip.jsxinc
*/
Folder.prototype.copy = function(tarFolder) {
    var srcFolder = this;
	var listOfFiles = new Array();
	
	if(!isFolder(tarFolder, true)) {
		tarFolder.create();
	}
	
    listOfFiles = srcFolder.getFiles("*.*");
    for (; listOfFiles.length > 0; ) {
        tFile = listOfFiles.pop();
        if (tFile instanceof Folder) {
            var tempFolder = Folder(tarFolder.fsName.concat("\\", tFile.displayName));
            
			if (!isFolder(tempFolder, true)) {
				tempFolder.create()
			}
            
			tFile.copy(tempFolder);
        }
        else {
            tFile.copy(tarFolder.fsName.concat("\\", tFile.displayName));
        }
    }
}
Folder.prototype.getFilesRecursive = function() {
	var folder = this;
	var editfiles = new Array();
	var files = folder.getFiles("*.*");
	for(var i = 0; i<files.length; i++)
	{
		var tempfile = files[i];
		 if (isFolder(tempfile)) {/* Load folder recursive */
			 var tmpfolder = new Folder(tempfile);
			 var temparray = tmpfolder.getFilesRecursive();
			 editfiles = editfiles.concat(temparray);
		 }
		else if(isFile(tempfile)) {
			 editfiles.push(tempfile);
		}
	}
	return editfiles;
}
function removeFolder(folder) {
	
	var string = 'rd "'+folder.fsName+'" /s /q';
	ExecuteBatchFile(string);
	
}
function isFolder(folder, mustexist) {//This is a function and not a prototype because this function must be available for all data types
	if(!mustexist)
		mustexist = false;
	
	var isfolder = false;
	if(folder instanceof Folder)
	{
		isfolder = true;
		
		if(mustexist)
			if(!folder.exists)
				isfolder = false;
	}
	return isfolder
}
Object.prototype.isLinked = function(type) {
	
	//This function works for the FileManager and the TopicManager.
	
    var file = this;
    var alltypes = "all";
     if(!type)
        type = alltypes;
 
	if(currentProject == null)
    {
        alert("Please load the project info using the function loadcurrentproject().");
        return null;
    }

	var allowedparents = new Array("[object TopicManager]", "[object FileManager]");
	if(!in_array(file.parent, allowedparents))
	{
		alert("The isLinked method can only be used on topics from the TopicManager and files from the FileManager.");
		return null;
	}
	
	if(!file.valid)//Check to see if topic/file exists
        return false;
	
	if(!is_array(LinkedFMDocs) || !is_array(LinkedWordDocs))
		loadLinkedFiles();
    
	var FileRelPath = file.path.substring(projectpath().length).replace(/\//g, "\\");
		
	var LinkedFiles = new Array();
    var linked = false;
 
    if(type.toLowerCase() == "framemaker" || type == alltypes)//Check FM
        LinkedFiles = LinkedFiles.concat(LinkedFMDocs);
    if(type.toLowerCase() == "word" || type == alltypes)//Check Word
        LinkedFiles = LinkedFiles.concat(LinkedWordDocs);
 
	if(in_array(FileRelPath.toLowerCase(), LinkedFiles.toLowerCase()))
		linked = true;
		
    return linked;
}
function unloadLinkedFiles() {
	LinkedFMDocs = false;
	LinkedWordDocs = false;
}
function loadLinkedFiles() {
	var Xpath = "//genfile/filename";
	var loadFilesThatAreLinked = function(filepath) {
		var LinkedFiles = new Array();
        var ContainerFile = new File(filepath);
        if(ContainerFile.exists)
        {
			var ContainerXML = new XML(ContainerFile.readFile());
			var LinkedFilesinContainer = ContainerXML.xpath(Xpath).children();
			for(var i = 0; i< LinkedFilesinContainer.length();i++)
			{
				LinkedFiles.push(LinkedFilesinContainer[i].toString());
			}
			return LinkedFiles;
        } else {
			return null;
		}
    }
	//Load FrameMaker
	LinkedFMDocs = loadFilesThatAreLinked(projectpath()+FMContainer);
	//Load Word
	LinkedWordDocs = loadFilesThatAreLinked(projectpath()+WordContainer);
}
function isValidType(value) {
    if (typeof (value) !== 'undefined' && value != null) {
        return true;
    }
    return false;
}

function confirm(message, noAsDflt, title) {
	/* Shorthand for Window.confirm because RoboHelp doesn't support the shorthand. */
	if(!message)
		return null;
	if(!noAsDflt)
		noAsDflt = false;
	if(!title)
		title = false;
	
	if(title == false)
		return Window.confirm(message, noAsDflt);
	else
		return Window.confirm(message, noAsDflt, title);
}

function prompt(message, preset, title) {
	/* Shorthand for Window.prompt because RoboHelp doesn't support the shorthand. */
	if(!message)
		return null;
	if(!preset)
		preset = "";
	if(!title)
		title = false;
	
	if(title == false)
		return Window.prompt(message, preset);
	else
		return Window.prompt(message, preset, title);
}
function clearmsg() {
	if(IsRoboHelp9OrLater() && currentProject != null)
		RoboHelp.project.clearOutputViewLog();
}
function closeproject() {
	if(currentProject == null)
	{
		loadcurrentproject(false);
		if(currentProject == null)
		{
			alert("Cannot close the current project as there is no project opened.");
			return null;
		}
	}
	
	var tmpproject = currentProject;
	unloadcurrentproject();
	RoboHelp.closeProject();
	return true;
}
function loadcurrentproject(showerror) {//If project is loaded after the library is initialized, this function must be run to initialize the variable currentProject
	if(!showerror)
		if(showerror != false)
			showerror = true;
	
	if(projectavailable())
		currentProject = RoboHelp.getCurrentProject();
	else if(showerror)
		alert("There is no RoboHelp project to load. Try loading the project and calling the function getcurrentproject() again.");
}
function msg(message) {
	if(currentProject != null)
		RoboHelp.project.outputMessage(message);
}
function openproject(xpjpath, updateifrequired) {
	if(!updateifrequired)
		updateifrequired = false;
	
	if(!isValidType(xpjpath) || !isValidFilePath(xpjpath, xpjextension))
		return false;
	
	var prj = new File(xpjpath);
	if(prj.folder()+"/" == projectpath())
	{
		alert("This project is already open.");
		return false;
	}
	else
	{
		unloadcurrentproject();//Unload current project from variable currentProject.
		RoboHelp.openProject(prj.fsName, updateifrequired);//Open project
		loadcurrentproject(false);//Load opened project into variable currentProject.
		return true;
	}
	
}
function openprojectdialog(updateifrequired) {
	if(!updateifrequired)
		updateifrequired = false;
	
	var prj = new File();
	prj = prj.openDlg("Choose project to open", "Project file:*.xpj", false);
	if(!isValidType(prj) || !isValidFilePath(prj.fsName, xpjextension))
		return false;
	
	return openproject(prj.fsName, updateifrequired);

}
function unloadcurrentproject() {
	unloadCSH();
	unloadLinkedFiles();
	currentProject = null;
}
function projectavailable() {
	if(isValidType(RoboHelp.getCurrentProject()))
		return true;
	else
		return false;
}

function projectpath() {
	if(currentProject != null)
		return currentProject.path.replace(/\\/g, "/")+"/";
	else
		return null;
}
function projecttitle() {
	if(currentProject != null)
		return currentProject.title;
	else
		return null;
}
function projectlanguage() {
	if(currentProject == null)
		return null
	else
	{
		var projectlang = "en";
		if (IsRoboHelp9OrLater()) {
			try {
				projectlang = RoboHelp.Language.getNameFromID(currentProject.language);
			} catch (e) {
				//Silently swallow exceptions
			}
		}
		return projectlang;
	}
}
function IsRoboHelp9OrLater() {
    var versionString = RoboHelp.version;
    var iVersion = parseInt(versionString);
    return (iVersion >= 9);
}
function saveSetting(setting, value, scope) {
    
    if(!scope) {
        scope = "project";
    }
	
    if(currentProject == null && scope != "global") {
		return false;
	}

	var settings = allSettings(scope);
	if(settings == false || settings.toString().isEmpty())//No file yet or empty
		settings = new XML("<scriptsettings/>");
	
	//Is this setting already availble?
	if(!settings.child(setting).toString().trim().isEmpty()) {
		settings.replace(setting, new XML("<"+setting+"><![CDATA["+htmlspecialchars(value)+"]]></"+setting+">"));//Replace existing value
	} else {
		settings.appendChild(new XML("<"+setting+"><![CDATA["+htmlspecialchars(value)+"]]></"+setting+">"));//Add new value
	}

	
	var settingsFileResource = getSettingsFile(scope);
    settingsFileResource.content("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"+settings.toXMLString());
	return true;
}
function loadSetting(setting, scope) {
	if(!scope) { scope = "project"; }
    
    if(currentProject == null && scope != "global") {
		return null;
	}
	var settings = allSettings(scope);
	if(settings == false || settings.toString().isEmpty()) {
		return null;
	} else {
		return settings.child(setting).toString();
	}
}
function allSettings(scope) {
     var settingsFileResource = getSettingsFile(scope);
	if(isFile(settingsFileResource), true)//Does the settings file already exist?
		return new XML(settingsFileResource.content());
	else
		return false;
}
function getSettingsFile(scope) {
    //Settings file name
    var settingsFile = "scriptSettingFile.xml";
    
    if(scope == "global") {
        var settingsFile = new File(Folder.appData.fsName + '/'+ settingsFile);
    } else if (currentProject != null){
        var settingsFile = new File (projectpath()+settingsFile);
    } else {
        var settingsFile = null;
    }
    return settingsFile;
}
Object.prototype.outputDir = function() {
	
	if(this.parent != "[object SSLManager]") {
	   alert("You can only use the method .outputDir() on SSL objects");
	   return null;
	}
	
	return folder(this.outputFileName)+"/";
}
String.prototype.count = function (s1) {   
        return (this.length - this.replace(new RegExp(s1,"g"), '').length) / s1.length;  
}
String.prototype.isEmpty = function () {
	var isempty = true;
	if(isValidType(this))
	{
		if(this.trim().length > 0)
			isempty = false;
	}
	return isempty;
}
String.prototype.toBoolean = function() {
	var truearray = new Array("true", "1");
	var falsearray = new Array("false", "0", "-1");
	if(in_array(this, truearray))
		return true;
	else if(in_array(this, falsearray))
		return false;
	else
		return null;
}
String.prototype.trim = function() {
	return this.replace(/^\s+|\s+$/g, "");
}
Object.prototype.balancedDelete = function (contentdelete) {
    var Token = this;
 
    if(Token.parent != "[object TokenManager]")
    {
        alert("You can only use the balancedDelete function on tokens from the TokenManager.");
        return null;
    }
 
    var SingleDelete = function(token) {
        var Single = false;
 
        if(token.tokenType == RoboHelp.TokenType.TOKENTEXT)
        {
            Single = true;
        }
        else if(token.tokenType == RoboHelp.TokenType.TOKENTAG)
        {
            if(token.name.match(/(<\/)/g) || token.name.match(/(\/>)/g))//End tags or shorthand tags
                Single = true;
            else
            {   
				//If no match of yet, make sure that the tag is not a known html shorthand tag. HTML 4.01 allows shorthand tags like <br>
				var ShortTags = new Array("area","base","basefont","br","col","frame","img","input","link","meta","param");
				if(token.isTag(ShortTags))
					Single = true;
			}
        }
        return Single;
    }
 
    if(SingleDelete(Token))
        Token.delete();
    else
    {
            var TokenDelete = new Array(Token);
            var tag = cleantag(Token.name);
            var endTag = "/"+tag;
            var i = 0;
            var RetreivedAll = false;
            var sToken = Token.next;
            while(RetreivedAll == false)
            {
                if(sToken.isTag(tag))
                {
                    i++;
                    if(contentdelete)
                        TokenDelete.push(sToken);
                }
                else if(sToken.isTag(endTag) && i != 0)
                {
                    i--;
                    if(contentdelete)
                        TokenDelete.push(sToken);
                }
                else if(sToken.isTag(endTag) && i == 0)
                {
                    TokenDelete.push(sToken);
                    RetreivedAll = true;
                 }
                else if(contentdelete)
                    TokenDelete.push(sToken);
 
                sToken = sToken.next;
            }
 
            for(var j = 0;j<TokenDelete.length;j++)
            {
                TokenDelete[j].delete();
            }
     }
    return true;
}
Object.prototype.hasAttribute = function(attribute, empty) {
	var Token = this;
 
     if(!empty)
        empty = false;
	
	if(Token.parent != "[object TokenManager]")
    {
        alert("You can only use the hasAttribute functions on tokens from the TokenManager.");
        return null;
    }
    else if(!attribute)
    {
        alert("No attribute specified");
        return null;
    }
 
    if(Token.tokenType != RoboHelp.TokenType.TOKENTAG)//It's not a tag at all
        return false;
 
    var hasAttribute = false;
 
    if(Token.getAttribute(attribute) != "")
        hasAttribute = true;
    else if(empty)//Search for empty attribute
    {
        var attrstring = attribute+'=("|\')';//Append =" or =' to attribute name.
        var attr = new RegExp(attrstring);
        if(Token.name.match(attr))
            hasAttribute=true;
    }
 
    return hasAttribute;
}
Object.prototype.isTag = function(Tag, casesensitive) {
    var Token = this;
	
	if(!casesensitive)
		casesensitive = false;
 
    if(Token.parent != "[object TokenManager]")
    {
        alert("You can only use the isTag functions on tokens from the TokenManager.");
        return null;
    }
 
    if(Token.tokenType != RoboHelp.TokenType.TOKENTAG)//It's not a tag at all
        return false;
 
    if(!Tag)//No tag specified and this is a tag so return true
        return true;
 
    var isTag = false;
    var fullTag = Token.name;
    var TagName = cleantag(fullTag);//Get the tag name without brackets
 
    if(!is_array(Tag))
    {
        var TagArray = new Array;
        TagArray[0] = Tag;
    } else {
        var TagArray = Tag;
    }
	
	if(!casesensitive)
	{
		//Matching is not case sensitive. Put everything in lower case
		TagName = TagName.toLowerCase();
		TagArray = TagArray.toLowerCase();
	}
 
	if(in_array(TagName, TagArray))
		isTag = true;

    return isTag;
}
function  cleantag (tag) {
	if(tag.match(" ")) {
		tag = tag.split(" ")[0];//Remove attributes the lazy way. All attributes are separated by spaces from the tag name.
	}
	
	tag = tag.replace(/[<>]/g, "");
	
    if(tag.substr(-1) == "/")
		tag = tag.substr(0,tag.length-1);
	
	return tag;
}
Object.prototype.CSH = function(topicid, mapnumber) {
	//Object to get the CSH of a topic.
	if(this.parent != "[object TopicManager]") {
		alert("The CSH method can only be used on topics from the TopicManager");
		return null;
	}
	
	//Project CSH settings are not initialized yet.
	if(CSH == false)
		loadCSH();
	
	var topicrelpath = this.path.toLowerCase().replace(/\\/g, "/").replace(projectpath().toLowerCase(), "");
	
	if(!topicid) {
		topicid = false;
		mapnumber = false;
	}
	
	//Get the CSH for the topic and return that.
	if(topicid === false) {
		var topicCSH = new Array();
		
		for(var i = 0; i<CSH.length; i++) {
			if(CSH[i][CSHTopicKey] != false) {
				if(CSH[i][CSHTopicKey].toLowerCase() == topicrelpath) {
					var tmpArray = [];
					tmpArray[CSHTopicidKey] = CSH[i][CSHTopicidKey];
					tmpArray[CSHMapnumberKey] = CSH[i][CSHMapnumberKey];
					
					topicCSH.push(tmpArray);
				}
			}
		}
		
		if(topicCSH.length >= 1)
			return topicCSH;
		else
			return false;
			
	} else {//Set CSH for the topic.
		
		msg("\nSetting CSH for topic \""+topicrelpath+"\"\n");
		
		var returnvalue = true;
		
		if(!in_array(topicid, TopicIds) && !in_array(mapnumber, MapNumbers)) {
			
			currentProject.MapIdManager.newMapId(topicid, mapnumber);
			currentProject.MapIdManager.assign(topicid, topicrelpath);
			
			//Add new mapnumbers to the correct arrays
			var tmpArray = new Array();
			tmpArray[CSHTopicidKey] = topicid;
			tmpArray[CSHMapnumberKey] = mapnumber;
			tmpArray[CSHTopicKey] = topicrelpath;
			CSH.push(tmpArray);
			
			MapNumbers.push(mapnumber);
			TopicIds.push(topicid);
		} else if (in_array(topicid, TopicIds) && in_array(mapnumber, MapNumbers)) {
			//Assume that given id's are assigned correctly.
			currentProject.MapIdManager.assign(topicid, topicrelpath);
			//Assign the topic to the id's in the CSH array.
			for(var i = 0; i<CSH.length; i++) {
				if(CSH[CSHTopicidKey] == topicid) {
					CSH[CSHTopicKey] = topicrelpath;
					break;
				}
			}
		} else {
			//There is something wrong
			returnvalue = false;
			alert("Error while assigning CSH. Map# and TopicId must both exists or must both be absent from project.");
		}
		
		return returnvalue;
		
	}
}
/* Support functions for File.convertUTF8()*/
File.prototype.convertUTF8 = function (fileencoding) {
	
	if(!fileencoding)//Default file encodings
		fileencoding = 'iso-8859-1';

	var file = this;    

	content = file.readFile(fileencoding);

	file.writeFile(content);
	
	return true;
	
}
function htmlspecialchars(string) {
	if(!string.isEmpty()) {
	   string = string.replace(/&/g,"&amp;");
	   string = string.replace(/</g,"&lt;");
	   string = string.replace(/>/g,"&gt;");
	   string = string.replace(/"/g,"&#039;");
	   string = string.replace(/'/,"&apos;");
	}
	return string;
}
File.prototype.zip = function (zipname, method, compression, archivecommand) {//Zip a single file
	var file = this;
	
	if(!isFile(file, true))
	{
		alert("File "+file.fsName+" does not exist. Cannot zip file.");
		return false;
	}
	else if(!ZipLocation())//No location. Cannot zip file
		return false;
	else if(zipname.isEmpty())
	{
		alert("No name for archive specified. Cannot zip file "+file.fsName);
		return false;
	}

	if(!method)
		method = "tzip";
	if(!compression)
		compression = false;
	if(!archivecommand)
		archivecommand = "a";
		
	var batchtxt = "";
		
	if(validZipMethod(method) && validZipCompression(compression) && validArchiveCommand(archivecommand))
	{
		batchtxt+='"'+v7Location+'" '+archivecommand+' -'+method+' "'+zipname+'" '+'"'+file.fsName+'"';
		if(compression != false)
			batchtxt+=' -mx'+compression;
			
		return ExecuteBatchFile(batchtxt);
	}
	else
	{
		alert("Invalid options for archive specified. Cannot zip file "+file.fsName);
		return false;
	}
	
}
Folder.prototype.zip = function (zipname, method, compression, archivecommand) {//zip a folder. This is always recursive
	var folder = this;
	
	if(!isFolder(folder, true))
	{
		alert("Folder "+folder.fsName+" does not exist. Cannot zip folder.");
		return false;
	}
	else if(!ZipLocation())//No location. Cannot zip file
		return false;
	else if(zipname.isEmpty())
	{
		alert("No name for archive specified. Cannot zip file "+file.fsName);
		return false;
	}

	if(!method)
		method = "tzip";
	if(!compression)
		compression = false;
	if(!archivecommand)
		archivecommand = "a";
	
	var batchtxt = "";
	
	if(validZipMethod(method) && validZipCompression(compression) && validArchiveCommand(archivecommand))
	{
		batchtxt+='"'+v7Location+'" '+archivecommand+' -'+method+' "'+zipname+'" '+'"'+folder.fsName+"\\*"+'"';
		if(compression != false)
			batchtxt+=' -mx'+compression;
			
		return ExecuteBatchFile(batchtxt);
	}
	else
	{
		alert("Invalid options for archive specified. Cannot zip folder "+folder.fsName);
		return false;
	}
	
}
/* Support functions for File.zip() and Folder.zip() */
function isValid7ZipPath () {
	if(!isValidFilePath(v7Location, "7z.exe")  && !isValidFilePath(v7Location, "7za.exe"))
		return false;
	else
		return true;
}
function validArchiveCommand(archivecommand) {
	var v7commands = new Array("a", "u");//Add to archive (or create new) / update file in archive, 
	if(in_array(archivecommand, v7commands))
		return true;
	else
		return false;
}
function validZipCompression(compression) {
	var v7compression = new Array("0", "1", "3", "5", "7", "9", false);//Compression goes: none, very low, fast, normal, high, ultra, use 7zip default.
	if(in_array(compression, v7compression))
		return true;
	else
		return false;
}
function validZipMethod(method) {
	var v7methods = new Array("t7z", "tgzip", "tzip", "tbzip2", "tiso", "tudf");//Supported archive types.
	if(in_array(method, v7methods))
		return true;
	else
		return false;
}
function ZipLocation() {//Add location of 7-Zip executable to v7Location. Return true on succes, false on fail.
	if(!isValid7ZipPath())
	{
		var ziploc = new File();
		ziploc = ziploc.openDlg("Please choose 7-Zip executable to zip the file","7-Zip executable: 7z.exe;7za.exe");
		if(isFile(ziploc, false))
			v7Location = ziploc.fsName;
			
		if(!isValid7ZipPath())
		{
			alert("The path to 7-Zip is not valid.");
			return false;
		}
	}
	return true;
}

	/* Run initial functions */
	loadcurrentproject(false);//Load the current project into the variable currentProject.
	
	libInit = true;//Set lib to loaded
}

var globallogfile = false;//Will hold the log file.

/* Recovery info */
var projectname;//Name of the project
var baggagefiles = new Array();//Will hold files to be added as baggege files.
var textonlytopics = new Array();//Will hold all topics that are text-only popups. Will be deleted from project.
var seealsokeywords = new Array();//Will hold the see also keywords.
var tempRH10 = new Array();//Will hold temporary recovery files. These files will be removed when the script finishes.

/* Recovery settings */
var BB_AIRLocation;//The location of the BB_AIR to restore.
var ProjectLocation;//The location to restore to.

/* BB_AIR files  (static) */
var jsindicator = "_xml.js";
var XMLprojectinfo = "whproj.xml";
var JSXMLprojectinfo = "whproj_xml.js"
var projectfiles = new Array();//Will hold all the files of the RoboHelp project. These files are excluded from the .fpj creation.
var projectfolders = new Array();//Will hold all the folders of the RoboHelp project. These folders are excluded from the .fpj creation.
var lngfile = "robohhre.lng";
var cshdatafile = "whcsh.xml";

/*  BB_AIR files (variable) */
var projectstartpage = false;
var projectbrowsesequencefile = false;
var projectdatapath = false;
var projecttoc = false;
var projectindex = false;
var projectglossary = false;
var projectsearch = false;

/* BB_AIR data */
var projectstartfile = false;
var projecttitle = false;
var projectlang = false;
var projectgentime = false;

/* RH project files */
var rootFPJ = "root.fpj";
var baggageFPJ = "rhbag.apj";
var lngfolder = "!Language!";
var snippetAPJ = "rhsnippet.apj";
var keywordAPJ = "rhakeyword.apj";
var aliasfileextenstion = ".ali";
var mapfilename = "BSSCDefault.h";
var synonymsfileextension = ".syn";

/* miniTOC file */
var miniTocCreated = false;
var miniTocReference = "minitoc";
var miniTocSnippetFile = miniTocReference+".hts";

/* BB_AIR output files */
var BB_AIRFiles = new Array(
	'rhair_fbody.htm',
	'main.hf',
	'ac_oetags.js',
	'ehlpdhtm.js',
	'standard.js',
	'whfhost.js',
	'whlang.js',
	'whtopic.js',
	'whutils.js',
	'whver.js',
	'RoboHHRE.lng',
	'cshapp.swf',
	'flexproj.swf',
	'sbrollovers.swf',
	'SearchOptions.xml',
	'whbrs.xml',
	'whcsh.xml',
	'whlang.xml',
	'whproj.xml',
	'windowslist.xml',
);
/*
	Since most manipulation proceeds from outside RoboHelp, we need a custom log.
*/
function log(logmessage) {
	
	//Create timestamp for in log file
	if(!debug) {
		debug = false;
	}
	
	var date = new Date();
	var debugclear = false;
	
	var addZero = function (string) {
		if(string.length<2) {
			string = '0'+string;
		}
		return string;
	}
	
	var year = date.getFullYear().toString();
	var month = addZero(date.getMonth().toString());
	var day = addZero(date.getDay().toString());
	
	var hours = addZero(date.getHours().toString());
	var minutes = addZero(date.getMinutes().toString());
	var seconds = addZero(date.getSeconds().toString());
	
	var time = hours + ':' + minutes + ':' + seconds;

	var timestamp = year+'-'+month+'-'+day+' '+time;
	
	//Initialize the log file only once.
	if(globallogfile == false) {
		
		globallogfile = logfileinit(year+'-'+month+'-'+day+' '+hours+'.'+minutes);
		
		if(debug && isFile(globallogfile, true)) {
			debugclear = true;
		}
		
	}
	
	globallogfile.encoding = 'UTF-8';
	
	//Open the log file. If it doesn't exitst, create it.
	if(isFile(globallogfile, true) && !(debug && debugclear)) {
		globallogfile.open("a");
		debugclear = false;
	} else {
		/*
			Debug creates a single log file. Always clear the file on run.
		*/
		globallogfile.open("w+");
	}
	
	globallogfile.write(timestamp+"\t"+logmessage+"\n");
	globallogfile.close();	
}
function logfileinit(date) {
	
	var logfile;
	
	if(debug) {
		var logfilename = "BB_AIR Recovery debug.log";
	} else {
		var logfilename = "BB_AIR Recovery "+date+".log";
	}
	
	var correct = false;
	
	if(correct == false) {
		/* The temp log save directory. */
		var folder =$.fileName;

		folder = folder.replace(/\\/g,"/");
		folder = folder.substring(0,folder.lastIndexOf("/")+1);	
	}

	logfile = new File(folder+logfilename);
	
	return logfile;
	
}
function savelogfile(folder) {

	var logfolder = new Folder(folder);

	var tmplog = new File(logfolder.fsName + '/' + globallogfile.name);
		tmplog.content(globallogfile.content());
		
		globallogfile.remove();
		globallogfile = tmplog;
	
}
var resource = "dialog { \
	properties: { \
		closeButton: true, \
	}, \
	text: 'Recover RoboHelp project from Browser Based AIR Help created by RoboHelp 10', \
	source: Group { \
		orientation: 'column', \
		txt: StaticText { text: 'The directory of of the output:' }, \
		source: Group { \
			orientation: 'row', \
			source: EditText { characters: 60 }, \
			btn: Button { text: '...', size: ['30','20']  }, \
		}, \
	}, \
	target: Group { \
		orientation: 'column', \
		txt: StaticText { text: 'The location to recover the output to:' }, \
		target: Group { \
			orientation: 'row', \
			target: EditText { characters: 60 }, \
			btn: Button { text: '...', size: ['30','20']  }, \
		}, \
	}, \
	log: Group { \
		orientation: 'column', \
		txt: StaticText { text: 'The location to save the log file:' }, \
		log: Group { \
			orientation: 'row', \
			log: EditText { characters: 60 }, \
			btn: Button { text: '...', size: ['30','20'] } \
		}, \
	}, \
	copyright: StaticText { text: 'Version 01-11-2012 - Copyright by Willam van Weelden, all rights reserved' }, \
	buttons: Group { \
		orientation: 'row', \
        alignment: ['right', 'top'], \
		run: Button { text: 'Recover project' }, \
		endscript: Button { text: 'Cancel' }, \
	}, \
}";
var gui = new Window(resource);

function prepareGUI() {
	
	gui.source.source.btn.onClick = chooseSource;
	gui.target.target.btn.onClick = chooseTarget;
	gui.log.log.btn.onClick = chooseLog;
	
	gui.buttons.run.onClick = validateGUI;
	gui.buttons.endscript.onClick = endScript();
	
}
function endScript() {
	/* Remove temp files and end script */
	removeTempFiles();
	gui.hide();
}
function validateGUI() {
	var source = gui.source.source.source.text;
	var target = gui.target.target.target.text;
	var log = gui.log.log.log.text;
	
	var run = true;
	
	if(source.isEmpty()) {
		alert("You must choose a source folder.");
		run = false;
	} else {
		var folder = new Folder(source);
		if(!isFolder(folder, true)) {
			alert("The source folder does not exist.");
			run = false;
		} else if(!isBB_AIRFolder(folder)) {
			alert("The source folder does not contain a valid BB_AIR output.");
			run = false;
		}
	}
	
	if(!run) {
		gui.source.source.source.active = true;
	} else {
	
		if(target.isEmpty()) {
			alert("You must choose a folder to recover the project.");
			run = false;
		} else {
			var folder2 = new Folder(target);
			
			if(!isFolder(folder2, true)) {
				alert("The source folder does not exist");
				run = false;
			} else if(folder2.fsName.toString().toLowerCase().substring(0,source.length) == source.toLowerCase()) {
				alert("You cannot select the recovery folder or a subfolder from the output you want to recover.");
				run = false;
			} else if(!emptyFolder(folder2)) {
				alert("You did not select an empty folder to recover the project.");
				run = false;
			}
		}
		
		if(!run) {
			gui.target.target.target.active = true;
		} else {
			
			if(log.isEmpty()) {
				alert("You must choose a folder to save the log file.");
				run = false;
			} else {
				
				var logfolder = new Folder(log);
				if(!isFolder(logfolder, true)) {
					run = false;
					alert("The folder to store the log file does not exist.");
				} else if(log.toLowerCase().substring(0,source.length) == source.toLowerCase()) {
					alert("You cannot store the log file in the output you want to recover.");
					run = false;
				} else if(log.toLowerCase().substring(0,target.length) == target.toLowerCase()) {
					alert("You cannot store the log file in the directory you want to recover the project.");
					run = false;
				}
				
			}
			
			if(run) {
				prepareGlobalVars(source, target);/* Set global variables */
				
				savelogfile(log);/* Save the log file to the correct folder. */
				
				gui.close();
				
				RecoverProject();
			} else {
				gui.log.log.log.active = true;
			}
		
		}
	}
	
}
function prepareGlobalVars(source, target) {
    
	BB_AIRLocation = new Folder(source);
	ProjectLocation = new Folder(target);
	log("Output will be recovered to \""+ProjectLocation.fsName+"\"");			

}

function chooseSource() {
	var folder = new Folder();
	var chosenFolder = folder.selectDlg("Choose the folder with the Browser Based AIR Help project to recover.");
	
	if(chosenFolder == null) {
		if(confirm("You must select a folder. Choose again?")) {
			chooseSource();
		}
	} else if(isBB_AIRFolder(chosenFolder)) {
		gui.source.source.source.text = chosenFolder.fsName;
	} else if(confirm('The chosen folder does not contain a valid Browser Based AIR Help output. Choose again?')) {
		chooseSource();
	}
}

function emptyFolder (folder) {
	var files = folder.getFiles("*");
	
	if(files.length > 0)
		return false;
	else
		return true;
}

function chooseTarget() {
	
	var folder = new Folder();
	var chosenFolder = folder.selectDlg("Choose the folder where the recovered BB_AIR project will be stored");
	if(chosenFolder != null) {
		
		var go = true;
		
		if(!emptyFolder(chosenFolder)) {
			if(Window.confirm("You have to choose an empty folder to recover your project in. Choose another folder?")) {
				go = false;
				chooseTarget();
			}
		}
		
		if(go) {
			var sourcefolder = gui.source.source.source.text;
			if(!sourcefolder.isEmpty()) {
				
				if(chosenFolder.fsName.toString().toLowerCase().substring(0,sourcefolder.length) == sourcefolder.toLowerCase()) {
					if(Window.confirm("You cannot select the recovery folder or a subfolder from the output you want to recover. Do you want to select another folder?")) {
						go = false;
						chooseTarget();
					}
				}
			}
		}
		
		if(go) {
			gui.target.target.target.text = chosenFolder.fsName;
		}
		
	} else if(Window.confirm("Not a valid folder. Do you want to choose again?")){
		chooseTarget();
	}
}

function chooseLog() {
	var folder = new Folder();
	var chosenFolder = folder.selectDlg("Choose the folder to save the log file");
	
	if(chosenFolder != null) {
	
		var source = gui.source.source.source.text;
		var target = gui.target.target.target.text;
		
		var go = true;
		
		if(!source.isEmpty()) {
			if(chosenFolder.fsName.toString().toLowerCase().substring(0,source.length) == source.toLowerCase()) {
				go = false;
				if(Window.confirm("You cannot store the log file in the output you want to recover. Choose again?")) {
					chooseLog();
				}
				
			}
		}
		
		if(go) {
			if(!target.isEmpty()) {
				if(chosenFolder.fsName.toString().toLowerCase().substring(0,target.length) == target.toLowerCase()) {
					go = false;
					if(Window.confirm("You cannot store the log file in the directory you want to recover the project. Choose again?")) {
						chooseLog();
					}
					
				}
			}
		}
		
		if(go) {
			gui.log.log.log.text = chosenFolder.fsName;
		}
	
	} else if (Window.confirm("Not a valid folder. Do you want to choose again?")) {
		chooseLog();
	}
}
function createBaggage() {
	/*
	
	The followinge files are not added as baggage files:
		* Style sheets
		* Images (png, gif, jpg and bmp)
		* none file
	*/
	
	var excludedextensions = new Array('.css','.png','.gif','.jpg', '.bmp', "");//The empty extensions exludes files without extension. This is the 'none' file
	
	var xml = '<?xml version="1.0" encoding="utf-8"?>'+"\n"+'<rhpml majorversion="3" minorversion="0"><files>';
	
	for(var i = 0; i<baggagefiles.length; i++) {
		var b = baggagefiles[i];
		
		if(!in_array(extension(b), excludedextensions)) {
		
			var relpath = b.substring((ProjectLocation.fsName.length+1), b.length);
		
			xml+='<file><name>'+relpath+'</name><usercreated>true</usercreated><comments/></file>';
		}
	}
	
	xml += '</files></rhpml>';
	
	var baggagefile = new File(ProjectLocation.fsName + '/' + baggageFPJ);
	baggagefile.content(xml);
	
}
function createProject() {
	
	var firsttopictitle = "recoveryprojectfirsttopic";
	projectname = projecttitle.replace(/[^a-zA-Z0-9\- ]+/g,'_');
	
	log("Now creating recovery project.");
	
	//Create a new project
	if(projectlang == false)//When project language is unknown
		RoboHelp.newProject("", projectname, ProjectLocation.fsName, projecttitle, firsttopictitle);
	else//If the project language is recovered
		RoboHelp.newProject("", projectname, ProjectLocation.fsName, projecttitle, firsttopictitle, parseFloat(projectlang), true);
	
	if(debug)
		log("Created recovery project "+projectname);
	
	//Close the project
	RoboHelp.closeProject();
	
	if(debug)
		log("Closed recovery project for mass editing.");
	
	//Remove the first topic
	var firsttopic = new File(ProjectLocation.fsName + "/" + firsttopictitle+".htm");
	firsttopic.remove();
	
	if(debug)
		log("Removed the required first topic.");
	
	//Remove root.fpj
	var root = new File(ProjectLocation.fsName + "/root.fpj");
	root.remove();
	
	if(debug)
		log("Removed root.fpj.");
	
	//Trash the CPD
	var cpd = new File(ProjectLocation.fsName + "/" + projectname + ".cpd");
	cpd.remove();
	
	if(debug)
		log("Removed the CPD file.");
	
	log("New project for recovery created.");
}
function getProjectFiles(dir) {
	
	var existingfiles = dir.getFiles("*");
	for(var i = 0; i<existingfiles.length; i++) {
		var file = existingfiles[i];
		
		if(isFile(file)) {
			//log("Found file: "+file.fsName);
			projectfiles.push(file);
		} else if(isFolder(file)) {
			//log("Found folder: "+file.fsName);
			projectfolders.push(file);
			getProjectFiles(file);
		}
	}
}
function importFiles(folder) {
	
	ProjectLocation;
	BB_AIRLocation;
	
	var relpath = "";
	if(folder.fsName != BB_AIRLocation.fsName) {
		relpath += folder.fsName.substring(BB_AIRLocation.fsName.length)+"/";
	} else {
		relpath = "/";
	}
	
	var files = folder.getFiles("*");
	for(var i = 0; i<files.length; i++) {
		var file = files[i];
		
		if(isProjectFolder(file)) {
			//Create folder in project
			var tocreate = new Folder(ProjectLocation.fsName+relpath+file.name);
			if(!isFolder(tocreate, true)) {
				if(!tocreate.create()) {
					log("Could not create folder "+tocreate.fsName);
				}
			}
			
			//Import files from folder
			importFiles(file);
		} else if(isFolder(file)) {
			//Filter folders. Folders that are not project folders (data folders) are excluded.
		} else if(isProjectFile(file)) {
			//log("Import file: "+file.fsName);
			//Copy file to recovery project
			if(!file.copy(ProjectLocation+relpath+file.displayName)) {
				log("Could not copy file \""+file.fsName+"\" to \""+ProjectLocation+relpath+file.displayName+"\"");
			}
		}
	}
	
}
function isProjectFolder(folder) {
	
	if(!isFolder(folder))
		return false;

	var BB_AIRfolders = Array("!ScreenLayout!","whdata", "whgdata", "whxdata", "resources", "Themes", projectdatapath);
	var is = true;
	for(var i = 0; i<BB_AIRfolders.length; i++) {
		var whfullfolder = BB_AIRLocation.fsName.replace(/\\/g, "/") + '/' +BB_AIRfolders[i];
		if(folder.fsName.replace(/\\/g, "/") == whfullfolder) {
			is = false;
			log("Skipping import of files in BB_AIR data folder "+whfullfolder);
			break;
		}
	}
	return is;
}
function isProjectFile(file) {
	
	var path = BB_AIRLocation.fsName.replace(/\\/g, "/") + "/";
	var fullstartfile = projectstartfile.fsName.replace(/\\/g, "/");
	
	
	var _csh = fullstartfile.replace(".htm", "_csh.htm");//csh start file
	var _rhc = fullstartfile.replace(".htm", "_rhc.htm");//csh start file;
	
	var fpclean = file.fsName.replace(/\\/g, "/");
	
	var BB_AIRfile = function(fullfilename, path) {
		
		var isBB_AIRFile = false;		
		for(var j = 0; j < BB_AIRFiles.length; j++) {
			
			var BB_AIRFile = path+BB_AIRFiles[j];
			if(BB_AIRFile == fullfilename) {
				isBB_AIRFile = true;//This is a BB_AIR control file. Do not import.
				break;
			}
		}
		
		return isBB_AIRFile;
		
	}
	
	function probableBB_AIRImage(image) {
	
		var BB_AIRImageExtenstions = new Array(".jpg", ".gif");
		
		if(!in_array(extension(image),BB_AIRImageExtenstions)) {
			
			return false;
		
		} else {
			
			var name = filename(image);
			var BB_AIRindication = new Array("wht_", "whd_", "ss_btn");
			
			var probable = false;
			
			for(var i = 0; i<BB_AIRindication.length; i++) {
				if(name.length <= BB_AIRindication[i]) {
					continue;
				} else if(name.substring(0, BB_AIRindication[i].length) == BB_AIRindication[i]) {
					//This file is almost certainly a default BB_AIR skin image. Examples: wht_idx.gif and wht_idx_h.gif
					return true;
				}
			}
			
		}
	}
	
	function RH10BBAIRJSXML(fullfilename) {
		if(fullfilename.substr(-jsindicator.length) == jsindicator) {
			return true;
		} else {
			return false;
		}
	}
	
	if(fpclean == fullstartfile) {//Is it the start file?
		return false;
	} else if(fpclean == _csh || fpclean == _rhc){//Is it the legacy start file?
		return false;
	} else if(BB_AIRfile(fpclean, path)) {//Is this a BB_AIR output file?
		return false;
	} else if(RH10BBAIRJSXML(fpclean)) {
		return false;
	} else if(probableBB_AIRImage(fpclean)) {//This is almost certainly a default RoboHelp BB_AIR icon. Do not import.
		return false;
	} else {//File may be imported into the project.
		return true;
	}
}
function createFPJ(folder) {
	
	var isRHProjFile = function(file) {
		var is = false;
		for(var i = 0; i<projectfiles.length; i++) {
			var pj = projectfiles[i].fsName;
			if(pj == file.fsName) {
				is = true;
				break;
			}
		}
		return is;
	}
	
	var isRHProjFolder = function(folder) {	
		
		var is = false;
		for(var i = 0; i<projectfolders.length; i++) {
			var pj = projectfolders[i].fsName;
			if(pj == folder.fsName) {
				is = true;
				break;
			}
		}
		return is;
	}
	
	var isTopic = function(file) {

		if(isRHProjFile(file)) {
			return false;
		}
		
		var topicextensions = new Array(".htm", ".html");
		if(in_array(extension(file.displayName), topicextensions)) {
			return true;
		} else {
			return false;
		}
	}
	
	var isBaggage = function (file) {
		if(isFolder(file)) {
			return false;
		}
		
		if(isRHProjFile(file)) {
			return false;
		}
		
		var notbaggageextenstions = new Array(".css");
		if(in_array(extension(file.fsName), notbaggageextenstions)) {
			return false;
		} else {
			return true;
		}
	}
	
	
	var filesinfolder = new Array();
	var foldersinfolder = new Array();
	
	var files = folder.getFiles("*");
	for(var i = 0; i< files.length; i++) {
		
		var file = files[i];
		
		if(isFolder(file)) {
			
			if(!isRHProjFolder(file)) {
				//Add as folder to FPJ
				foldersinfolder.push(file.displayName);
				
				//Create FPJ recursive
				createFPJ(file);
				
			}
			
		} else if(isTopic(file)) {
			//log("Add file to FPJ: "+file.fsName);
			//Add as topic to FPJ
			filesinfolder.push(file.displayName);
			
		} else if(isBaggage(file)) {
			/* Add as a baggage file */
			var projectpath = ProjectLocation.fsName.replace(/\\/g, "/");
			var relpath = file.fsName.replace(/\\/g, "/");
				relpath = relpath.substring(projectpath);
		
			baggagefiles.push(relpath);
		} else {
			//log("Skipping file: "+file.fsName);
		}
		
	}
	
	var fpj = '<?xml version="1.0" encoding="utf-8"?>'+"\n"+'<rhpml majorversion="3" minorversion="0">"';
	
	if(foldersinfolder.length > 0) {
		fpj+="<folders>";
		for(var i = 0; i<foldersinfolder.length; i++) {
			var f = foldersinfolder[i];
			fpj += "<folder><name>"+f+"</name></folder>";
		}
		fpj+="</folders>";
	}
	
	if(filesinfolder.length > 0) {
		fpj += "<topics>";
		for(var i = 0; i<filesinfolder.length; i++) {
			var f = filesinfolder[i];
			fpj += "<topic><name>"+f+"</name><comments></comments><frameset>0</frameset></topic>";
		}
		fpj += "</topics>";
	}
	
	fpj+= '</rhpml>';
	
	if(folder.fsName == ProjectLocation.fsName) {
		var filename = rootFPJ;
	} else {
		var filename = folder.displayName+".fpj";
	}
	
	var FPJFile = new File(folder.fsName + '/' + filename);
	
	log("Creating FPJ file: "+FPJFile.fsName);	
	
	FPJFile.content(fpj);
	
}
function recoverCSH() {
	
	var cshfile = new File(BB_AIRLocation.fsName+'/'+cshdatafile);
	var csh = new Array();
	
	
	if(!isFile(cshfile)) {
		log("Cannot recover CSH data as CSH data file is not present");
	} else {
		
		log("Recovering CSH data from data file "+cshfile.fsName);
		
		var tokens = RoboHelp.getTokenManager(cshfile.fsName);
		if(typeof(tokens)!='undefined') {
			if(tokens.count>0)  {
				var token = tokens.item(1);
				while(typeof(token)!='undefined') {
					
					if(token.isTag("item")) {
						tmparray = new Array();
						tmparray['alias'] = token.getAttribute("mapid");
						tmparray['number'] = token.getAttribute("mapnum");
						tmparray['topic'] = token.getAttribute("topicurl");
						csh.push(tmparray);
					}
					
					token = token.next;
				}
			}
		}
	}
	
	if(csh.length > 0 ) {
	
		var aliasfile = new File(ProjectLocation.fsName + '/' + projectname + aliasfileextenstion);
		var mapfile = new File(ProjectLocation.fsName + '/' + mapfilename);
			
		var aliasstring = '<?xml version="1.0" encoding="utf-8"?>'+"\n"+'<aliaslist version="1.0">';
		var mapstring = '';
		
		for(var i = 0; i<csh.length; i++) {
			
			aliasstring += '<alias name="'+csh[i]['alias']+'" link="'+csh[i]['topic']+'"></alias>';
			mapstring += "#define "+csh[i]['alias']+"\t"+csh[i]['number']+"\n";
		}
		
		aliasstring += '</aliaslist>';
		
		aliasfile.content(aliasstring);
		mapfile.content(mapstring);
	}
	
}
function recoverTOC() {
	
	if(projecttoc == false) {
		log("No TOC resource file. Cannot recover TOC.");
		return false;
	}
	
	//Try to find the TOC resource file
	var foundTOC = true;
	var TOCFile = new File(BB_AIRLocation.fsName+'/'+projectdatapath+'/'+projecttoc);
	if(!isFile(TOCFile, true)) {
		foundTOC = false;
		log("Could not find TOC file "+TOCFile.fsName);
		
		//Fallback
		TOCFile = new File(BB_AIRLocation.fsName+'/whxdata/'+projecttoc);
		if(isFile(TOCFile, true)) {
			foundTOC = true;
			log("Found TOC file through fallback method: "+TOCFile.fsName);
		}
	}
	
	if(foundTOC) {
		log("Found TOC file: "+TOCFile.fsName);
		
		
		log("Start TOC recovery");
		
		//Now get the TOC content
		var TOCString = getTOCData(TOCFile.fsName);
		TOCString += "</toc>";
		
		//Get the TOC file, there is always a single TOC (.hhc) file made in a new project
		var RHToc = ProjectLocation.getFiles("*.hhc")[0];
		
		/* Get the current TOC string */
		var replacestring = RHToc.content();
			
		//Replace the end of the file with the TOC. This is done so the properties that are set by RH are preserved.
		replacestring = replacestring.replace("</toc>", TOCString);
		
		//Write the TOC
		RHToc.content(replacestring);
		
		log("TOC has been recovered.");
		
	} else {
		log("Could not find TOC file. Skipping TOC recovery.");
		return false;
	}
	
}
function getTOCData(file) {
	
	log("Now reading TOC data file: "+file);
	
	var tocString = "";
	
	var tokens = RoboHelp.getTokenManager(file);
	if(typeof(tokens)!='undefined') {
		if(tokens.count>0) {
			var token = tokens.item(1);
			while(typeof(token)!='undefined') {
				
				if(token.isTag("toc")) {
					//This is the TOC start file.
					if(token.hasAttribute("root")) {
						tocString += getTOCData(folder(file)+'/'+token.getAttribute("root"));
					}
				} else if(token.isTag("chunk")) {
					//The TOC is split into multiple files.
					if(token.hasAttribute("ref")) {
						tocString += getTOCData(folder(file)+'/'+token.getAttribute("ref"));
					}
				} else if(token.isTag("book")) {
					//Create a new book in the TOC
					var bookname = "Book without a name";
					if(token.hasAttribute("name")) {
						bookname = token.getAttribute("name");
					}
					
					tocString += '<item name="'+bookname+'"';
					
					if(token.hasAttribute("url")) {
						tocString += ' url="'+token.getAttribute("url")+'"';
					}
					
					tocString += '>';
					
				} else if(token.isTag("/book")) {
					//Close a book item.
					tocString += '</item>';
				
				} else if(token.isTag("item")) {
					//Create a new TOC item
					if(!token.hasAttribute("url")) {
						continue;
					} else {
						var itemname = "Page without a name";
						if(token.hasAttribute("name")) {
							itemname = token.getAttribute("name");
						}
						
						tocString += '<item name="'+itemname+'" link="'+token.getAttribute("url")+'" ></item>';
					}
				} else if(token.isTag("project")) {
					if(token.hasAttribute("name")) {
						//Create a placeholder for a merged project
						var mergedname = token.getAttribute("name");
						tocString += '<item name="'+mergedname+'" merge="::/" merge2="'+mergedname+'" ></item>';
					}
				}
				
				token = token.next;
			}
		}
	}
	
	return tocString;
}
function recoverIDX() {
	if(projectindex == false) {
		log("No index resource file. Cannot recover index.");
		return false;
	}
	
	var foundIDX = true;
	var IDXFile = new File(BB_AIRLocation.fsName+'/'+projectdatapath+'/'+projectindex);
	if(!isFile(IDXFile, true)) {
		foundIDX = false;
		log("Could not find index file "+IDXFile.fsName);
		
		//Fallback
		IDXFile = new File(BB_AIRLocation.fsName+'/whxdata/'+projectindex);
		if(isFile(IDXFile, true)) {
			foundIDX = true;
			log("Found index file through fallback method: "+IDXFile.fsName);
		}
	}
	
	if(foundIDX) {
		
		log("Found index file: "+IDXFile.fsName);
		
		
		log("Start index recovery");
		
		var IDXString = getIDXData(IDXFile.fsName);
		IDXString += "</index>";
		
		//Get the IDX file, there is always a single index (.hhk) file!
		var RHIDX = ProjectLocation.getFiles("*.hhk")[0];
		
		/* Get the current index string */
		var replacestring = RHIDX.content();
		
		//Replace the end of the file with the index. This is done so the properties that are set by RH are preserved.
		replacestring = replacestring.replace("</index>", IDXString);
		
		//Write the index
		RHIDX.content(replacestring);
		
		log("Index has been recovered.");
		
	} else {
		log("Could not find index file. Skipping index recovery.");
		return false;
	}
	
}
function getIDXData(file) {
	
	log("Now reading index data file: "+file);
	
	var indexString = "";
	
	var emptyIndexKeyString = "Recoverd index entry without name ";
	var indexKeyCounter = 0;
	
	var tokens = RoboHelp.getTokenManager(file);
	if(typeof(tokens)!='undefined') {
		if(tokens.count>0) {
			var token = tokens.item(1);
			while(typeof(token)!='undefined') {
				
				if(token.isTag("chunkinfo")) {
					//The index is split into multiple files.
					if(token.hasAttribute("url")) {
						indexString += getIDXData(folder(file)+'/'+token.getAttribute("url"));
					}
				} else if(token.isTag("key")) {
					
					//Create a new key in the index
					if(token.hasAttribute("name")) {
						indexString += '<item name="'+token.getAttribute("name")+'">';
					} else {
						indexString += '<item name="'+emptyIndexKeyString+indexKeyCounter+'">';
						indexKeyCounter++;
					}
					
				} else if(token.isTag("/key")) {
					//Close a key entry
					indexString += '</item>';
				
				} else if(token.isTag("topic")) {
					//Create a new index item
					if(token.hasAttribute("url") && token.hasAttribute("name")) {
						indexString += '<section name ="'+token.getAttribute("name")+'" link="'+token.getAttribute("url")+'"></section>';
					}
				}
				
				token = token.next;
			}
		}
	}
	
	return indexString;
}
function recoverGlossary() {
	
	if(projectglossary == false) {
		log("No glossary resource file. Cannot recover glossary.");
		return false;
	}
	
	var foundGLO = true;
	var GLOFile = new File(BB_AIRLocation.fsName+'/'+projectdatapath+'/'+projectglossary);
	if(!isFile(GLOFile, true)) {
		foundGLO = false;
		log("Could not find glossary file "+GLOFile.fsName);
		
		//Fallback
		GLOFile = new File(BB_AIRLocation.fsName+'/whxdata/'+projectglossary);
		if(isFile(GLOFile, true)) {
			foundGLO = true;
			log("Found glossary file through fallback method: "+GLOFile.fsName);
		}
	}
	
	if(foundGLO) {
		log("Found glossary file: "+GLOFile.fsName);
		
		
		log("Start glossary recovery");
		
		var GLOString = '<?xml version="1.0" encoding="utf-8" ?>'+"\n"+'<glossary version="1.0">"';
		GLOString += getGLOData(GLOFile.fsName);
		GLOString += '</glossary>';
		
		//Get the glossary file, there is always a single glossary (.glo) file!
		var RHGLO = ProjectLocation.getFiles("*.glo")[0];
		RHGLO.content(GLOString);
		
		log("Glossary has been recovered.");
		
	} else {
		log("Could not find the glossary file. Skipping glossary recovery.");
		return false;
	}
	
}
function getGLOData(file) {
	
	log("Now reading glossary data file: "+file);
	
	var GLOString = "";
	
	var tokens = RoboHelp.getTokenManager(file);
	if(typeof(tokens)!='undefined') {
		if(tokens.count>0) {
			var token = tokens.item(1);
			while(typeof(token)!='undefined') {
				
				if(token.isTag("chunkinfo")) {
					//The glossary is split into multiple files.
					if(token.hasAttribute("url")) {
						GLOString += getGLOData(folder(file)+'/'+token.getAttribute("url"));
					}
				}  else if(token.isTag("entry")) {
				
					if(token.hasAttribute("name") && token.hasAttribute("value")) {
						GLOString += '<glossentry>';
						
						GLOString += '<glossterm>'+token.getAttribute("name")+'</glossterm>';
						GLOString += '<glossdef>'+token.getAttribute("value")+'</glossdef>';
						
						GLOString += '</glossentry>';
					}
				}
				
				token = token.next;
			}
		}
	}
	
	return GLOString;
}
function recoverBrowseSequences() {
	
	if(projectbrowsesequencefile == false) {
		log('No browse sequence resource file. Cannot recover browse sequences.');
		return false;
	}
	
	var foundBRS = true;
	var BRSFile = new File(BB_AIRLocation.fsName+'/'+projectbrowsesequencefile);
	if(!isFile(BRSFile, true)) {
		log("Could not find browse sequence file.");
	}
	
	if(foundBRS) {
		log("Now recovering browse sequences");
		
		//Get the BRS file, there is always a single brs (.brs) file!
		var RHBRS = ProjectLocation.getFiles("*.brs")[0];
		
		//Get BRS string
		var BRSString = BRSFile.content();
		
		//Write BRS info
		RHBRS.content(BRSString);
		
		log("Browse sequences recovered");
		
	} else {
		log("Could not find browse sequence file. Skipping browse sequence recovery.");
		return false;
	}
}
function recoverLNG() {
	
	var langfile = new File(BB_AIRLocation.fsName+'/'+lngfile);
	if(!isFile(langfile, true)) {
		log("No language file found in BB_AIR directory. Cannot recover language file.");
		return false;
	}
	
	log("Now recovering language file: "+langfile.fsName);
	var lngString = getLNGString(langfile);
	
	if(IsRoboHelp9OrLater()) {
		var locget = new Folder(ProjectLocation+'/'+lngfolder);
		var files = locget.getFilesRecursive();
		for(var i = 0; i<files.length; i++) {
			var file = files[i];
			if(filename(file.fsName).toLowerCase() == lngfile.toLowerCase()) {
				var rlngfile = file;
				break;
			}
		}
	} else {
		//RoboHelp 8
		var rlngfile = new File(ProjectLocation+'/'+lngfile);
	}
	
	if(!rlngfile) {
		alert("No language file found! Cannot recover language file.");
	} else {
		rlngfile.content(lngString);
		log("Language file recovered to: "+rlngfile.fsName);
	}
}

function getLNGString(file) {
	
	log("Now recovering language settings from file: "+file.fsName);
	
	var content = file.content();
	
	//log(content);
	
	var setting = false;
	
	var lngstring = '<?xml version="1.0" encoding="utf-8"?>'+"\n<configuration>";
	
	var s = content.split("\n");
	
	
	for(var i = 0; i<s.length; i++) {
		var line = s[i];
		
		line = line.trim();
		
		if(line.length < 1) {
			continue;
		}
		
		if(line.substr(0,1) == "[" && line.substr(-1) == "]") {
			//New section
			if(setting != false) {
				lngstring+='</section>';
			}
			
			setting = line.substring(1, line.length-1);
			lngstring += '<section name="'+setting+'">';
			
		} else if(line.match("=")) {
			//Value
			v = line.split("=");
			lngstring += '<element name="'+htmlspecialchars(v[0])+'" value="'+htmlspecialchars(v[1])+'" />';
		}
		
	}
	
	return lngstring+'</section></configuration>';
}
function recoverSynonyms() {
	
	if(projectsearch == false) {
		log("No search resource file. Cannot recover synonyms.");
		return false;
	}
	
	var foundsearch = true;
	var ftsFile = new File(BB_AIRLocation.fsName+'/'+projectdatapath+'/'+projectsearch);
	if(!isFile(ftsFile, true)) {
		foundTOC = false;
		log("Could not find search file "+ftsFile.fsName);
		
		//Fallback
		ftsFile = new File(BB_AIRLocation.fsName+'/whxdata/'+projectsearch);
		if(isFile(ftsFile, true)) {
			foundsearch = true;
			log("Found search file through fallback method: "+ftsFile.fsName);
		}
	}
	
	
	if(foundsearch) {
		
		var foundsynonyms = false;
		
		var tokens = RoboHelp.getTokenManager(ftsFile.fsName);
		if(typeof(tokens)!='undefined') {
			if(tokens.count>0) {
				var token = tokens.item(1);
				while(typeof(token)!='undefined') {
					
					if(token.isTag("index")) {
						if(token.getAttribute("type") == "Synonym") {
							foundsynonyms = token.getAttribute("url");
						}
					}
					
					token = token.next;
				}
			}
		}
	
		if(foundsynonyms != false) {
			
			if(IsRoboHelp9OrLater()) {
				var locget = new Folder(ProjectLocation+'/'+lngfolder);
				var files = locget.getFilesRecursive();
				for(var i = 0; i<files.length; i++) {
					var file = files[i];
					if(filename(file.fsName).toLowerCase() == projectname.toLowerCase() + synonymsfileextension) {
						var synonymsfile = file;
						break;
					}
				}
			} else {
				var synonymsfile = new File(projectlocation + '/' + projectname + synonymsfileextension);
			}
			
			if(!synonymsfile) {
				log("No syonymsfile found. Cannot recover synonyms");
			} else {
				synonymsfile.content(getSynonymsContent(BB_AIRLocation.fsName+'/'+projectdatapath+'/'+foundsynonyms));
				log("Synonyms recovered to file: "+synonymsfile.fsName);
			}
			
			
		}
	
	}
}
function getSynonymsContent(file) {
	
	var synonyms = new Array();

	var tokens = RoboHelp.getTokenManager(file);
	if(typeof(tokens)!='undefined') {
		if(tokens.count>0) {
			var token = tokens.item(1);
			while(typeof(token)!='undefined') {
				
				if(token.isTag("wd")) {
					var tmparray = new Array();
					tmparray['name'] = token.getAttribute("nm");
					tmparray['synonym'] = token.getAttribute("sy");
					
					synonyms.push(tmparray);
				}
				
				token = token.next;
			}
		}
	}
	
	var content = '<?xml version="1.0" encoding="utf-8"?>'+"\n"+'<Synonyms FormatVersion="2" FeatureVersion="2"><ExcludeWordList/><DirectionalSynList>';
	
	for(var i = 0; i<synonyms.length; i++) {
		content += '<DirectionalSyn AllForms="1"><From>'+synonyms[i]['synonym']+'</From><To>'+synonyms[i]['name']+'</To></DirectionalSyn>';
	}
	
	content += '</DirectionalSynList><GroupSynList/></Synonyms>';
	return content;
}
/*
	This function will evaluate the given folder and determine whether this is a BB_AIR output that can be recovered.
	
	The function will also set several global project variables.
*/
function isBB_AIRFolder(folder) {
	
	log("Check folder to see whether it is a recoverable BB_AIR folder.");
	
	var BBAIRIndication = new File(folder.fsName + '/' + 'ac_oetags.js');
	if(!isFile(BBAIRIndication, true)) {
		return false;
	}
	
	var JSXMLprojectFile = new File(folder.fsName + '/' + JSXMLprojectinfo);
	if(!isFile(JSXMLprojectFile)) {
		log("Folder \""+folder.fsName+"\" cannot be restored because the file \""+JSXMLprojectFile+"\" is not present.");
		return false;
	} else {
		log('Converting RoboHelp 10 WebHelp to readable format.');
		convertRH10BBAIR(folder);
		log('Converted RoboHelp 10 WebHelp to readable format.');
	}
	
	var XMLprojectFile = new File(folder.fsName + '/' + XMLprojectinfo);
	if(!isFile(XMLprojectFile, true)) {
		log("Folder \""+folder.fsName+"\" cannot be restored because the file \""+XMLprojectinfo+"\" is not present.");
		alert("It seems you are trying to restore an output that uses Dynamic User Centric Content.\nPoint to the output you want to restore instead of main output folder.");
		return false;
	}
	
	/* Retreive project info from project XML file. This information is (partially required). */
	
	//Use tokens instead of XML for easy checking
	var xmltokens = RoboHelp.getTokenManager(XMLprojectFile.fsName);
	if(typeof(xmltokens)!='undefined') {
		if(xmltokens.count>0) {
		
			if(debug)
				log("Retreiving project information through the file "+XMLprojectinfo);
		
			var token = xmltokens.item(1);
			while(typeof(token)!='undefined') {
				if(token.isTag("project")) {
					
					if(token.hasAttribute("homepage")) {
						projectstartpage = token.getAttribute("homepage");
						log("Found project start page. Start page is: "+projectstartpage);
					}
					
					if(token.hasAttribute("langid")) {
						
						if(projectlang != false && projectlang != token.getAttribute("langid")) {
							log("Project language code from XML resource is different from language code from project info HTML file. Will use XML resource language.");
						} else {
							log("Found project language. Project language code is: "+projectlang);
						}
						projectlang = token.getAttribute("langid");
					}
					
					if(token.hasAttribute("title")) {
						projecttitle = token.getAttribute("title");
						log("Found project title. Title is: "+projecttitle);
					}
					
					if(token.hasAttribute("datapath")) {
						projectdatapath = token.getAttribute("datapath");
						log("Found project data path. Data path is: "+projectdatapath);
					}
					
					if(token.hasAttribute("toc")) {	
						projecttoc = token.getAttribute("toc");
						log("Found project toc data file. Data file is: "+projecttoc);
					}
					
					if(token.hasAttribute("index")) {
						projectindex = token.getAttribute("index");
						log("Found project index data file. Data file is: "+projectindex);
					}
					
					if(token.hasAttribute("glossary")) {
						projectglossary = token.getAttribute("glossary");
						log("Found project glossary data file. Data file is: "+projectglossary);
					}
					
					if(token.hasAttribute("fts")) {
						projectsearch = token.getAttribute("fts");
						log("Found project search data file. Data file is: "+projectsearch);
					}
					
					if(token.hasAttribute("brs")) {
						projectbrowsesequencefile = token.getAttribute("brs");
						log("Found project browse sequence data file. Data file is: "+projectbrowsesequencefile);
					}
				}
				token = token.next;
			}
		}
	} else {
		log("Could not retreive project information through the file "+XMLprojectinfo);
	}
	
	/* Show which elements could not be retreived. (Non vital) */
	if(!projectgentime)
		log("Could not find project generation time.");
	if(!projectlang)
		log("Could not find project language.");
	if(!projectstartpage)
		log("Could not find project start page name.");
	if(!projecttoc)
		log("Could not find project toc data file name.");
	if(!projectindex)
		log("Could not find project index data file name.");
	if(!projectglossary)
		log("Could not find project glossary data file name.");
	if(!projectbrowsesequencefile)
		log("Could not find project project browse sequence data file name.");
	
	
	var datadirfound = true;
	if(!projectdatapath) {
		datadirfound = false;
	} else {
		var datadir = new Folder(folder.fsName + '/' + projectdatapath);
		if(!isFolder(datadir, true))
			datadirfound = false;
	}
	
	if(!datadirfound) {
		if(projecttoc || projectindex || projectglossary) {
			if(Window.confirm("The script could not find the project data directory.\nIf you continue, the project will be restored without TOC, index and glossary.\nDo you want to continue the recovery?")) {
				log("The data directory could not be retreived.");
			} else {
				log("Required data directory was not found. User stopped recovery.");
				return false;
			}
		}
	}
	
	if(!projectstartfile) {
		
		var defaultStartfile = 'index.htm';
		projectstartfile = new File(folder.fsName + '/' + defaultStartfile);
		
		if(!isFile(projectstartfile, true)) {
			
			alert('Could not find the project start file.\nPlease select the project start file.\n(The file used to open the help.)');
			
			var tmpFile = new File(projectstartfile.fsName);
			projectstartfile = tmpFile.openDlg('Could not find the project start file.\nPlease select the project start file.\n(The file used to open the help.)', "*.htm", false);
			
			if(!projectstartfile  == null) {
				projectstartfile = false;
			}
			
		}
		
		
	}
	
	
	if(!projecttitle) {
		
		log("Could not retreive project title from project start page.");
		var mytitle = Window.prompt("The project could not be found. Please enter the project title.","Project title", "Please enter project title");
		
		if(mytitle) {
			projecttitle = mytitle;
			log("Project title \""+projecttitle+"\" given. Script will now use this title.");
		} else {
			log("Invalid project title given. Therefore this output cannot be restored.");
			return false;
		}
		
	}
	
	
	return true;
}
function cleanTopics() {
	log("Now cleaning topics.");
	
	var files = ProjectLocation.getFilesRecursive();
	for(var i = 0; i<files.length; i++) {
		if(extension(files[i].fsName) == ".htm") {
			cleanTopic(files[i].fsName);
		}
	}
	
	log("All topics have been cleaned.");
}
function cleanTopic(topicURI) {
	
	if(debug)
		log("Cleaning topic file "+topicURI);
	
	var lookforexpandspot = false;
	var textpopup = new Array();
	var linkid;
	var idlinkholder = "";
	
	var tokens = RoboHelp.getTokenManager(topicURI);
	if(typeof(tokens) != "undefined") {
		if(tokens.count > 0) {
			var token = tokens.item(1);
			
			while(typeof(token) != "undefined") {
				
				if(token.isTag("meta")) {
					
					if(token.getAttribute("name") == "MS-HAID") {
						seealsokeywords.push(token.getAttribute("content"));/* Push See also keywords. */
					}
					
				} else if(token.isTag("script")) {
				
					/* Check whether the script is a BB_AIR script. Preserve custom scripts as best as possible. */
					var removeToken = false;
					
					if(token.hasAttribute("src")) {						
						
						var src = token.getAttribute("src").replace(/(..\/|.\/)/g, "").toLowerCase();
						if(in_array(src, BB_AIRFiles)) {
							removeToken = true;/* This is a BB_AIR script */
						}
					} else {
						var contentraw = token.next.name;
						var content = contentraw.replace(/(\r\n|\r|\n)/g, "");
						
						var idelemindicator = 'TextPopupInit(';
						if(content.indexOf(idelemindicator) != -1) {
							idlinkholder += contentraw;
						}
						
						
						/* The following texts indicate a BB_AIR inserted script. */
						var rhScriptIndicators = new Array("function reDo()","AddMasterBreadcrumbs(","addTocInfo(", "addAvenueInfo(", "addButton(", "highlightSearch();","if (window.writeIntopicBar)","WritePopupMenuLayer();",idelemindicator);
						for(var i = 0; i<rhScriptIndicators.length; i++) {
							if(content.indexOf(rhScriptIndicators[i]) != -1) {
								removeToken = true;
								break;
							}
						}
						
						if(!removeToken) {
							log("The topic "+topicURI+" contains a custom script that will not be deleted. Please check in topic whether script should be retained.");
						}
					}
					
					if(removeToken) {
						token.balancedDelete(true);
					}
					
				} else if(token.isTag("a")) {
					
					if(token.hasAttribute("name")) {
						/* Remove MiniToc bookmarks */
						if(token.getAttribute("name").indexOf("MiniTOCBookMark") != -1) {
							token.balancedDelete(false);
						}
					}
					
					if(token.hasAttribute("class")) {
						
						if(token.getAttribute("id").indexOf("MTHotSpot") != -1) {/* Minitoc placeholder */
							
							/* Create minitoc snippet if it does not yet exist. */
							if(!miniTocCreated) {
								createMiniTocSnippet();
							}
							
							/* Get the parent element of the tag. Done so any text nodes are skipped and only a p tag is returned. Div and body are safeguards. */
							var holdertoken = token.previous;
							var stoparray = new Array('p', 'div', 'body');
							while(!holdertoken.isTag(stoparray)) {
								holdertoken = holdertoken.previous;
							}
							
							if(holdertoken.isTag("p")) {
								holdertoken.insertText('<?rh-placeholder type="snippet" ref="'+miniTocReference+'" ?>', false);
								holdertoken.balancedDelete(true);
							} else {
								log('Could not determine parent of MiniToc because the program could not find a paragraph element in which the show link was added. Topic of this error: '+topicURI);
							}
							
						} else if(token.getAttribute("class") == "dropspot") {/* Dropspot */
							
								token.removeAttribute("name");
								
								var tmparray = new Array();
								tmparray['a'] = token.getAttribute("id");
								
								textpopup.push(tmparray);
							
						} else if(token.getAttribute("class") == "expandspot") { /* Expandspot */
							token.removeAttribute("name");
							
							var tmparray = new Array();
							tmparray['a'] = token.getAttribute("id");
							
							textpopup.push(tmparray);
							
							
						} else if(token.getAttribute("class") == "BSSCPopup") { /* Popup*/
							
							var onclick = token.getAttribute("onclick");
							onclick = onclick.replace("return false;", "");
							onclick = "javascript:"+onclick;
							
							token.setAttribute("href", onclick);/* Set correct HREF */
							
							/* Remove unneeded attributes */
							var removeattributes = new Array('name', 'onmouseover', 'class');
							for(var i = 0; i<removeattributes.length; i++) {
								token.removeAttribute(removeattributes[i]);
							}
							
							/* Add to list so correct js is added in topic */
							textpopup.push(token.getAttribute("id"));
							
						} if(token.getAttribute("class") == "popupspot") {/* Popupspot */
							
							var href = token.getAttribute("onclick");
							
							/* Remove attributes */
							var removeattributes = new Array('onmouseover', 'onclick');
							for(var i = 0; i<removeattributes.length; i++) {
								token.removeAttribute(removeattributes[i]);
							}
							
							href = href.substring(href.indexOf("'")+1, href.lastIndexOf("'"));
							
							var textonlypopupfilepath = folder(topicURI)+"/"+href;
							var text = getPopupText(textonlypopupfilepath);
							
							token.setAttribute("href", text);
							textonlytopics.push(textonlypopupfilepath);
							
						}
					} else if(token.hasAttribute("onclick")) {
						var onclick = token.getAttribute("onclick");

						if(onclick.indexOf("PopupMenu_Invoke") != -1 || onclick.indexOf("PickupDialog_Invoke") != -1 ) { /* See also or related topics control */
							//Delete these for now.
							token.balancedDelete(true);
						}
					}

				} else if(token.isTag("img")) {
					if(token.getAttribute("class") == "TwistyImage") {
						token.delete();/* Twisty image. Remove */
					}
					
				} else if(token.isTag("div")) {
					
					if(token.getAttribute("id") == "header" || token.getAttribute("id") == "footer") {
						//Remove headers and footers.
						token.balancedDelete(true);
					} else if(token.getAttribute("class") == "droptext" && token.getAttribute("id").indexOf("MTPOPUP") != -1) {/* Minitoc droptext */
						token.balancedDelete(true);
					}
					
				} else if(token.isTag("/body")) {
					
					/* Add script control for DHTML effects. */
					var start = '<?rh-script_start ?><script type="text/javascript" language="JavaScript1.2">//<![CDATA['+"\n";
					var startDHTML = "if( typeof( TextPopupInit ) != 'function' ) TextPopupInit = new Function();\n";
					var startPopup = "if( typeof( FilePopupInit ) != 'function' ) FilePopupInit = new Function();\n";
					var end = '//]]></script><?rh-script_end ?>';
					
					var content = "";
					
					var hasDHTML = false;
					var hasPopup = false;
					
					for(var i = 0; i<textpopup.length;i++) {
						
						var e = textpopup[i];
						
						if(is_array(e)) {/* Add dropdown or expandspot */
							hasDHTML = true;
							
							if(!e.hasOwnProperty('elem')) {
								e['elem'] = getCorrespondingElemId(e['a'], idlinkholder);
							}
							
							content += "\tTextPopupInit('"+e['a']+"', '"+e['elem']+"');\n";
						} else {
							hasPopup = true;
							content += "\tFilePopupInit('"+e+"');\n";
						}
						
					}
					
					if(content != "") {
						
						var writestring = start;
						if(hasDHTML) {
							writestring += startDHTML;
						}
						if(hasPopup) {
							writestring += startPopup;
						}
						
						writestring += content;
						
						writestring += end;
						
						token.insertText(writestring, false);
					}
					
				}
				
				/* Go to the next token */
				token = token.next;
			}
			
			tokens.save();
			tokens.close();
		}
	}
}
function getPopupText(fileURI) {

	var text;
	var font;
	var fontsize;
	var horizontalmargin;
	var verticalmargin;
	var fontcolor;
	var bgcolor;
	
	var tokens = RoboHelp.getTokenManager(fileURI);
	if(typeof(tokens) != "undefined") {
		if(tokens.count > 0) {
			var token = tokens.item(1);
			while(typeof(token) != "undefined") {
				var prev = token.previous;
				
				if(token.isTag("body")) {
					
					if(token.getAttribute("bgcolor").substring(0,1) != "#") {
						/*It's not a colour code but a color name.*/
						bgcolor = colorTextToHex(token.getAttribute("bgcolor").substring(1));
					} else {/* Convert colour code to correct format. */
						bgcolor = rgbToHex(token.getAttribute("bgcolor").substring(1));
					}
					
					if(token.hasAttribute("text")) {
						fontcolor = colorTextToHex(token.getAttribute("text"));
					} else {
						fontcolor = "00000000";
					}
					
					var style = token.getAttribute("style");
					
					var horizontal = "margin-left:";
					var vertical = "margin-top:";
					
					horizontalmargin = style.substring(horizontal.length, style.indexOf(";"));
					
					var split = style.split(vertical);
					verticalmargin = split[1].substring(0, split[1].indexOf(";"));
					
				}
				
				if(token.isTag("span") || token.isTag("font")) {
					var style = token.getAttribute("style");
					if(token.isTag("span")) {
						var font = style.substring(style.indexOf(":")+1, style.indexOf(";"));
					} else {
						var fontsize = style.substring(style.indexOf(":")+1, style.indexOf("p"));
						
						/* Text is always inside the font tag */
						var text = token.next.name.toString().trim();
					}
				}
				
				token = token.next;
			}
		}
	}
	
	return "JavaScript:hhctrl.TextPopup('"+text+"','"+font+","+fontsize+"',"+horizontalmargin+","+verticalmargin+","+fontcolor+","+bgcolor+")";
	
}
function rgbToHex(hex) {
	/* The text only popup uses another notation for colors than CSS. Convert to correct code */
	var rgb;
	if(hex == "000000") {
		rgb = "00"+hex;
	} else {
		rgb = "0x"+hex.substr(-2)+hex.substring(0,4);
	}
	
	return rgb.toLowerCase();
}
function colorTextToHex (colorname) {
	colorname = colorname.toLowerCase();
	var color;
	switch(colorname) {
		case "red":
			color = "0x0000ff";
			break;
		case "lime":
			color = "0x00ff00";
			break;
		case "blue":
			color = "0xff0000";
			break;
		case "maroon":
			color = "0x000080";
			break;
		case "green":
			color = "0x008000";
			break;
		case "navy":
			color = "0x800000";
			break;
		case "grey":
			color = "0x808080";
			break;
		case "white":
			color = "0xffffff";
			break;
		case "fuchsia":
			color = "0xff00ff";
			break;
		case "aqua":
			color = "0xffff00";
			break;
		case "yellow":
			color = "0x00ffff";
			break;
		case "purple":
			color = "0x800080";
			break;
		case "olive":
			color = "0x008080";
			break;
		case "teal":
			color = "0x808000";
			break;
		case "silver":
			color = "0xc0c0c0";
			break;
		case "#ffffc0":/* Color code is used here instead of name */
			color = "0xc0ffff";
			break;
		case "black":
			color = "00000000";
			break;
		default:
			color = "00000000";
	}
	return color;
}
function createMiniTocSnippet() {
		
	var snippetHTML = '<?xml version="1.0" encoding="utf-8" ?>'+"\n"+'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><html xmlns="http://www.w3.org/1999/xhtml"><head><meta http-equiv="Content-Type" content="text/html; charset=utf-8" /><meta name="topic-comment" content="" /><meta name="generator" content="Adobe RoboHelp 9" /><title>minitoc</title></head><body><div id="minitocdivplaceholder">	<?rh-placeholder type="minitoc" ph-style="font-weight: normal;font-style: normal;text-decoration: none;" 	 list-type="ul" caption="On this page:" caption-style="font-weight: normal;font-style: normal;text-decoration: none;" 	 margin=";;;" min-heading-level="h2" max-heading-level="h3" flags="7" ?></div></body></html>'
	var snippetFile = new File(ProjectLocation.fsName+"/"+miniTocSnippetFile);
	snippetFile.content(snippetHTML);
	
	var APJHTML = '<?xml version="1.0" encoding="utf-8"?>'+"\n"+'<rhpml majorversion="4" minorversion="0"><files><file><name>'+miniTocSnippetFile+'</name><comments>mini TOC snippet created by BB_AIR recovery script.</comments><category>miniTOC</category></file></files></rhpml>';
	var APJ = new File(ProjectLocation.fsName+"/"+snippetAPJ);
	APJ.content(APJHTML);
	
	miniTocCreated = true;
}
function getCorrespondingElemId(linkid, idlinkholder) {
	
	var id = false;
	var tmparray = idlinkholder.split('\n');
	for(var i = 0; i<tmparray.length; i++) {
		
		var e = tmparray[i];
		var checkid = "'"+linkid+"'";
		
		if(e.indexOf(checkid) != -1) {
			var f = e.split(',')[1];/* The section that holds the id */
			id = f.replace(/('|\)|;)/g, "");//Now we have the id. 
		}
		
	}
	return id.trim();
	
}
function removeTextOnlyPage() {
	
	var topics = currentProject.TopicManager;
	
	for(var i = 1; i<= topics.count; i++) {
		
		var topic = topics.item(i);
		var path = topic.path.toString().replace(/\\/g,"/").toLowerCase();
		
		for(var j = 0; j<textonlytopics.length; j++) {
			
			if(path == textonlytopics[j].toLowerCase()) {
			
				log("Removing text only popup topic: "+path);
			
				topic.delete();
				break;
			}

		}		
		
	}
	
	
}
function writeSeeAlsoKeywords() {
	
	if(seealsokeywords.length < 1) {
		return true;//Only create the keyword file if keywords exist.
	} else {
	
		var kwfile = new File(ProjectLocation.fsName+"/"+keywordAPJ);

		var content = '<?xml version="1.0" encoding="utf-8"?>'+"\n"+'<rhpml majorversion="4" minorversion="0"><keywords>';

		for(var i = 0; i<seealsokeywords.length; i++) {
			var kw = seealsokeywords[i];
			
			content += '<keyword><name>'+kw+'</name><keywords /></keyword>';
			
		}

		content += '</keywords></rhpml>';
		
		kwfile.content(content);
	}
	
}
function convertRH10BBAIR(folder) {
	var files = folder.getFilesRecursive();

	for(var i = 0; i<files.length;i++) {
		if(files[i].fsName.substr(-jsindicator.length) == jsindicator) {
			tempRH10.push(convertJStoXML(files[i].fsName));
		}
	}
}
function convertJStoXML(fullpath) {
	var name = fullpath.substring(0, fullpath.lastIndexOf(jsindicator))+".xml";
	
	var JSFile = new File(fullpath);
	var XMLFile = new File(name);
	
	var JSContent = JSFile.content();
	var XMLContent = JSContent.substr(JSContent.indexOf("\"")+1);
		XMLContent = XMLContent.substring(0, XMLContent.lastIndexOf("\""));
		XMLContent = XMLContent.replace(/\\"/g, "\"");
	
	XMLFile.content(XMLContent);
	
	return name.replace(/\\/g, "/");
}
function removeTempFiles() {
	log("Removing temporary files.");
	for(var i = 0; i<tempRH10.length; i++) {
		var temp = new File(tempRH10[i]);
		temp.remove();
	}
	log("Temporary files removed.");
}

var debug = false;//Debug mode?

/*
	Recover a project from BB_AIR output.
	
	1. Choose BB_AIR output to recover.
	2. Choose location to recover project.
	3. Recover project.
	
*/

if(!libInit) {
	alert("Please start RoboHelp to continue.");
} else if(currentProject != null) {
	if(Window.confirm("The script needs to close the current project. Proceed?")) {
		if(closeproject()) {
			GUI();
		} else {
			alert("Could not close the opened project. Please close the project manually and start the script using the ExtendScript Toolkit.");
		}
	}
} else {
	GUI();
}


function GUI() {
    prepareGUI();
	gui.show();
}

function RecoverProject() {
		
	alert("The script will now recover your project. This may take several minutes.\n\nSince RoboHelp is running the script, RoboHelp will not respond. Do NOT close RoboHelp.\n\nYou will receive a message when your project has been recovered.");
	
	/*
		Recover the BB_AIR project.
	*/

	/* Create a blank project. All resources will be imported into this project. */
	createProject();
	
	/* Get the project files. These files will be excluded when creating the .fpj files. */
	log("Now determining all project files and folders.");
	getProjectFiles(ProjectLocation);
	
	/* Import all files in the project */
	log("Now importing topics and other resources into BB_AIR project");
	importFiles(BB_AIRLocation);
	log("Resources imported into project.");
	
	/* All files are imported. Now restore  the fpj files */
	log("Now recreating the .fpj resources for the project.");
	createFPJ(ProjectLocation);
	
	/* Now add baggage files to the project. */
	log("Now creating baggage file resource for the project.");
	createBaggage();
	
	/* Recover TOC */
	recoverTOC();
    
    /* Revover index */
    recoverIDX();
    
    /* Recover glossary */
    recoverGlossary();
	
	/* Recover synonyms */
	recoverSynonyms();
    
    /* Recover browse sequences */
    recoverBrowseSequences();
    
    /* Recover lng file*/
    recoverLNG();
    
	/* Recover CSH */
	recoverCSH();
	
    /* Clean the topics */
    cleanTopics();
    
    /* Write see also keywords to keywordfile */
    writeSeeAlsoKeywords();
    
    /* Open project*/
    openproject(ProjectLocation.fsName + "/" + projectname + ".xpj");
    
    /* Remove text only popup pages */
    removeTextOnlyPage();
	
    log("Project recovered.");
    alert("The project has been recovered from the Browser Based AIR Help output.\n\nNow select 'Tools' > 'Update DHTML effects in topics'. That initializes the last phase of the cleanup.\n\nIf you do not update the DHTML effects, your project might become corrupted.\n\nThe script will now open the log file. Check the log file for any errors.");
    
    globallogfile.execute();
}
